#include <algorithm>
#include <iostream>
#include <vector>

struct Offer {
  int idx;
  int weight;
  int value;
  float rating;
} pom;

std::vector<Offer> offers;
bool cmpRating(const Offer &a, const Offer &b) { return a.value < b.value; }
bool cmpIndex(const Offer &a, const Offer &b) { return a.idx < b.idx; }
bool cmpValues(const std::tuple<std::vector<Offer>::iterator,
                                std::vector<Offer>::iterator, int> &a,
               const std::tuple<std::vector<Offer>::iterator,
                                std::vector<Offer>::iterator, int> &b) {
  return std::get<2>(a) > std::get<2>(b);
}

int main() {
  int n, W;
  float epsilon;
  std::cin >> n >> W >> epsilon;

  for (int i = 0; i < n; i++) {
    pom.idx = i + 1;
    std::cin >> pom.weight >> pom.value;
    pom.rating = (float)pom.value / (float)pom.weight;
    offers.push_back(pom);
  }
  std::sort(offers.begin(), offers.end(), cmpRating);

  int count = 0;
  int weight = 0;
  int value = 0;
  auto left = offers.begin();
  auto right = offers.begin();

  std::vector<std::tuple<std::vector<Offer>::iterator,
                         std::vector<Offer>::iterator, int>>
      r;
  while (right != offers.end()) {
    int nextWeight = right->weight;
    int nextValue = right->value;
    if (weight + nextWeight > W) {
      r.push_back(std::make_tuple(left, right, value));
    }
    while (weight + nextWeight > W) {
      weight -= left->weight;
      value -= left->value;
      left++;
      count--;
    }
    weight += nextWeight;
    value += nextValue;
    count++;
    right++;
    r.push_back(std::make_tuple(left, right, value));
  }
  std::sort(r.begin(), r.end(), cmpValues);
  left = std::get<0>(r[0]);
  right = std::get<1>(r[0]);

  std::vector<Offer> rez;
  for (auto it = left; it != right; it++) {
    rez.push_back(*it);
  }
  std::sort(rez.begin(), rez.end(), cmpIndex);

  std::cout << rez.size() << "\n";
  for (auto &offer : rez) {
    std::cout << offer.idx << " ";
  }
  return 0;
}